IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Cbtes_x_Conceptos') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [CPJ_Cbtes_x_Conceptos]
END
GO

CREATE PROCEDURE [dbo].[CPJ_Cbtes_x_Conceptos] @pJsonRecibido VARCHAR(8000)
AS 
SET NOCOUNT ON
/*Parametros*/

DECLARE		@pId_Usuario			INT,
			@pFlagUsarTrans			TINYINT,
			@pModoDebug				TINYINT,
			@pFechaDesde			DATETIME,
			@pFechaHasta			DATETIME,
		    @pTipo					CHAR(1),
			@pFormato				VARCHAR(3),     --D  Detallado   R Resumen por Concepto RM Resumen por Mes y Concepto
			@pFlag_Filtrar_Concept	TINYINT,
			@pId_Concepto			INT

			


SET @pId_Usuario				= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Usuario')), 0)
SET @pFlagUsarTrans				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'FlagUsarTrans')), 0)
SET @pModoDebug					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'ModoDebug')), 0)

SET @pFechaDesde				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'FechaDesde')),GETDATE())
SET @pFechaHasta				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'FechaHasta')),GETDATE())

SET	@pTipo						= ISNULL(CONVERT(CHAR(1), dbo.CF_JSON_VALUE(@pJsonRecibido,'Tipo')), 'P')
SET	@pFormato					= ISNULL(CONVERT(VARCHAR(3), dbo.CF_JSON_VALUE(@pJsonRecibido,'Formato')), 0)
SET	@pFlag_Filtrar_Concept		= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Flag_Filtrar_Concept')), 0)
SET	@pId_Concepto				= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Concepto')), 0)


  CREATE TABLE #Trans (Id_Trans INT)

  DECLARE @Existe_Tag_Conceptos 		INT
		  ,@e_Tag_Conceptos				SMALLINT
		  ,@Total						DECIMAL(16,2)


 
  DECLARE @Sql		    VARCHAR(MAX)
  DECLARE @SqlSaldo	    VARCHAR(MAX)
  DECLARE @SqlSelect	VARCHAR(MAX)
  DECLARE @SqlInto	    VARCHAR(MAX)
  DECLARE @SqlFrom	    VARCHAR(MAX)
  DECLARE @SqlWhere  	VARCHAR(MAX)
  DECLARE @SqlGroup	    VARCHAR(MAX)
  DECLARE @SqlOrder	    VARCHAR(MAX) 
  
  SET @e_Tag_Conceptos = 130
  SET @Existe_Tag_Conceptos = 0 
  
  IF @pFlag_Filtrar_Concept = 1
	 SET @Existe_Tag_Conceptos = ISNULL( (SELECT COUNT(*) FROM TagFile_ TAG WHERE TAG.TBL = @Existe_Tag_Conceptos AND TAG.USR = @pId_Usuario) ,0)


/************************************************************* Creo la tabla ***************************************************************************************/
  

  SELECT TOP 1 C.Fecha,p.Id_Concepto, p.Descripcion, C.Destinatario,C.Id_Trans, C.Id_Tipo_Cbte,Convert(varchar(3),'''') as Id_tipo_Val,0 as Conciliado,O.Importe as Imp_Concepto,C.Imp_Total,C.Imp_Percep, O.Importe
    INTO #Reporte
	FROM Cajas_Mov_Conceptos O, Cbtes C, Cbtes_Tipos T, Conceptos p
	WHERE C.Id_Trans = O.Id_Trans
	AND C.Id_Tipo_Cbte = T.Id_Tipo_Cbte
	AND P.Id_Concepto = O.Id_Concepto 
	AND C.Id_Estado_Cbte IN (1,4,2)
	AND 1=0


/************************************************************* Conbranzas por recibos ***************************************************************************************/
  IF (@pTipo = 'N')
  BEGIN
  SET @SqlSelect =  ' SELECT C.Fecha,p.Id_Concepto,p.Descripcion, C.Destinatario,C.Id_Trans, C.Id_Tipo_Cbte , V.Id_Tipo_Val,Isnull(B.CONCILIADO,0) AS Conciliado,ISNULL(O.Importe,0) AS Imp_Concepto,C.Imp_Total,C.Imp_Percep, SUM(ISNULL(v.Importe,0))*-1 AS Importe'
  SET @SqlGroup  =  ' GROUP BY C.Fecha,p.Id_Concepto,p.Descripcion, C.Destinatario,C.Id_Trans, C.Id_Tipo_Cbte, V.Id_Tipo_Val, B.CONCILIADO,C.Imp_Total,C.Imp_Percep,O.Importe'
  END
  ELSE
  BEGIN
    SET @SqlSelect =  ' SELECT C.Fecha,p.Id_Concepto,p.Descripcion, C.Destinatario,C.Id_Trans, C.Id_Tipo_Cbte,Convert(varchar(3),'''') as Id_Tipo_val,0 as Conciliado,ISNULL(O.Importe,0) AS Imp_Concepto,C.Imp_Total,C.Imp_Percep,ISNULL(O.Importe,0) AS Importe '
	SET @SqlGroup  = ''
  END

  SET @SqlInto = ' ' 

  SET @SqlWhere = 'WHERE C.Id_Trans = O.Id_Trans
							AND C.Id_Tipo_Cbte = T.Id_Tipo_Cbte
							AND P.Id_Concepto = O.Id_Concepto
							AND C.Id_Estado_Cbte IN (1,4,2)'

  IF @pId_Concepto != 0
		BEGIN
  			SET @SqlWhere = LTRIM(RTRIM(@SqlWhere)) + ' AND p.Id_Concepto = ' + CONVERT(VARCHAR(10),@pId_Concepto) 
		END

  IF (@pTipo = 'C')
		BEGIN
  			SET @SqlWhere = LTRIM(RTRIM(@SqlWhere)) + ' AND T.Compromete_Compras IN (1,-1) 
														AND C.Periodo_Iva >= ''' + CONVERT(VARCHAR(8),@pFechaDesde   ,112) + '''
														AND C.Periodo_Iva <  ''' + CONVERT(VARCHAR(8),@pFechaHasta+1 ,112) + ''' '
		END


  IF (@pTipo = 'P')
		BEGIN
	  		SET @SqlWhere = LTRIM(RTRIM(@SqlWhere)) + ' AND T.Compromete_Pagos IN (1,-1) 
		                                            AND C.Fecha >= ''' + CONVERT(VARCHAR(8),@pFechaDesde   ,112) + '''
													AND C.Fecha <  ''' + CONVERT(VARCHAR(8),@pFechaHasta+1 ,112) + ''' '
		END

  IF (@pTipo = 'N')
		BEGIN
	  		SET @SqlWhere = LTRIM(RTRIM(@SqlWhere)) + ' AND T.Compromete_Pagos IN (1,-1) 
				                                	AND M.Id_Trans = C.Id_Trans
					                                AND V.Id_Valor = M.ID_VALOR			                                        
		                                            AND ISNULL(B.Fecha_Acreditacion,isnull(V.Fecha_Acreditacion,C.fecha))  >= ''' + CONVERT(VARCHAR(8),@pFechaDesde   ,112) + '''
													AND ISNULL(B.Fecha_Acreditacion,isnull(V.Fecha_Acreditacion,C.fecha)) <  ''' + CONVERT(VARCHAR(8),@pFechaHasta+1 ,112) + ''' '
		END

  IF (@pTipo = 'V')
		BEGIN
	  		SET @SqlWhere = LTRIM(RTRIM(@SqlWhere)) + ' AND T.Compromete_Factura IN (1,-1) 
		                                            AND C.Periodo_Iva >= ''' + CONVERT(VARCHAR(8),@pFechaDesde   ,112) + '''
													AND C.Periodo_Iva <  ''' + CONVERT(VARCHAR(8),@pFechaHasta+1 ,112) + ''' '
		END

  IF (@pTipo = 'R')
		BEGIN
	  		SET @SqlWhere = LTRIM(RTRIM(@SqlWhere)) + ' AND T.Compromete_Recibos IN (1,-1) 
		                                            AND C.Fecha >= ''' + CONVERT(VARCHAR(8),@pFechaDesde   ,112) + '''
													AND C.Fecha <  ''' + CONVERT(VARCHAR(8),@pFechaHasta+1 ,112) + ''' '
		END

  IF (@pTipo = 'T')
		BEGIN
	  		SET @SqlWhere = LTRIM(RTRIM(@SqlWhere)) + ' AND T.Compromete_Trans_Fondos IN (1,-1) 
		                                            AND C.Fecha >= ''' + CONVERT(VARCHAR(8),@pFechaDesde   ,112) + '''
													AND C.Fecha <  ''' + CONVERT(VARCHAR(8),@pFechaHasta+1 ,112) + ''' '
		END

  IF @Existe_Tag_Conceptos > 0
  BEGIN
      IF (@pTipo = 'T' OR @pTipo = 'C' OR @pTipo = 'V' )
	  BEGIN
	      SET @SqlFrom = 'FROM Cbtes_Conceptos O, Cbtes C, Cbtes_Tipos T, Conceptos p ,TagFile_ TAG'
      END
      ELSE
	  BEGIN
	    IF @pTipo = 'N'
		   BEGIN
	          SET @SqlFrom = 'FROM Cajas_Mov_Conceptos O, Cbtes C, Cbtes_Tipos T, Conceptos p ,TagFile_ TAG
			                        , Valores V
			  						  LEFT JOIN Bancos_Ctas_Mov B  on V.ID_TRANS = B.ID_TRANS 
						                          AND CONVERT(VARCHAR,V.Valor_Nro) = CONVERT(VARCHAR,B.COMPROBANTE_NRO)
												  AND ABS(V.Importe) = ABS(B.Importe)
							        , Valores_Mov M '
           END
	       ELSE
		   BEGIN
	          SET @SqlFrom = 'FROM Cajas_Mov_Conceptos O, Cbtes C, Cbtes_Tipos T, Conceptos p ,TagFile_ TAG'
           END
      END
      SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND (O.Id_Concepto = TAG.PTR 
							      AND TAG.TBL = ' + CAST(@e_Tag_Conceptos  AS VARCHAR(10))  + '
								  AND TAG.USR = ' + CAST(@pId_Usuario AS VARCHAR(10)) + '
								 ) ' 

  END
  ELSE
  BEGIN
      IF (@pTipo = 'T' OR @pTipo = 'C' OR @pTipo = 'V' )
	  BEGIN
	      SET @SqlFrom = 'FROM Cbtes_Conceptos O, Cbtes C, Cbtes_Tipos T, Conceptos p '
	  END
      ELSE
	  BEGIN
	    IF @pTipo = 'N'
		   BEGIN
	          SET @SqlFrom = 'FROM Cajas_Mov_Conceptos O, Cbtes C, Cbtes_Tipos T, Conceptos p 
			                        , Valores V
			  						  LEFT JOIN Bancos_Ctas_Mov B  on V.ID_TRANS = B.ID_TRANS 
						                          AND CONVERT(VARCHAR,V.Valor_Nro) = CONVERT(VARCHAR,B.COMPROBANTE_NRO)
											   	  AND ABS(V.Importe) = ABS(B.Importe)
							        , Valores_Mov M '
           END
	       ELSE
		   BEGIN
	          SET @SqlFrom = 'FROM Cajas_Mov_Conceptos O, Cbtes C, Cbtes_Tipos T, Conceptos p '
           END 
	  END
  END

  SET @SqlOrder = 'Order by 1'

  SET @Sql = @SqlSelect + ' ' + @SqlInto +' '+ @SqlFrom + ' ' + @SqlWhere + ' ' + @SqlGroup  + ' ' + @SqlOrder 

 PRINT @Sql

 EXEC('INSERT INTO #Reporte ' + @sql)

 IF @pTipo = 'N' DELETE #Reporte WHERE Id_tipo_Val IN ('CHP','DB','AJU','DES') AND Conciliado = 0

 ALTER TABLE #Reporte ADD 
   Id_Concepto_1 INT,
   Descripcion_1 VARCHAR(100),
   Id_Concepto_2 INT,
   Descripcion_2 VARCHAR(100),
   Id_Periodo_Caja INT,
   Id_Caja INT,
   Descrip_Caja VARCHAR(100)
 
 UPDATE #Reporte SET Id_Concepto_1 = ISNULL(C.Id_Concepto_Padre,0)
	FROM #Reporte R, Conceptos C
		WHERE R.Id_Concepto = C.Id_Concepto

 UPDATE #Reporte SET Id_Concepto_1 = Id_Concepto
	FROM #Reporte R WHERE R.Id_Concepto_1 = 0

UPDATE #Reporte SET Id_Concepto_2 = ISNULL(C.Id_Concepto_Padre,0)
	FROM #Reporte R, Conceptos C
		WHERE R.Id_Concepto_1 = C.Id_Concepto

 UPDATE #Reporte SET Id_Concepto_2 = Id_Concepto_1
	FROM #Reporte R WHERE R.Id_Concepto_2 = 0

UPDATE #Reporte SET Descripcion_1 = C1.Descripcion , Descripcion_2 = C2.Descripcion
	FROM #Reporte R, Conceptos C1, Conceptos C2
		WHERE R.Id_Concepto_1 = C1.Id_Concepto
		AND R.Id_Concepto_2 = C2.Id_Concepto

							 
/************************************************************* total***************************************************************************************/
 SET @Total = (SELECT SUM(Importe) FROM #Reporte)
 

  /************************************************************* Resultado ***************************************************************************************/
 
  IF UPPER(@pFormato) = 'D' OR @pFormato = ''
  BEGIN
     IF (@pTipo IN ('P','R','N') )
		BEGIN
			 UPDATE #Reporte SET Id_Periodo_Caja = C.Id_Periodo_Caja, Id_Caja = P.Id_Caja, Descrip_Caja = A.Descripcion,
			    Importe = Convert(Decimal(20,2),Abs(R.Imp_Concepto) * abs(R.Importe)/(ABS(R.Imp_total)+ABS(R.Imp_percep))*-1)
				FROM #Reporte R, Cajas_Mov C, Cajas_Periodos P, Cajas A 
				WHERE R.Id_Trans = C.Id_Trans 
					AND P.Id_Periodo_Caja = C.Id_Periodo_Caja
					AND P.Id_Caja = A.Id_Caja
					

		END

	 SELECT * FROM #Reporte  ORDER BY  ID_TRANS,Fecha, Descripcion
  END

  IF UPPER(@pFormato) = 'R'
     SELECT Id_Concepto_2, Descripcion_2, Id_Concepto_1, Descripcion_1, Id_Concepto, Descripcion,SUM(Importe) AS Importe, CONVERT(DECIMAL(7,2),SUM(Importe) / @Total * 100) AS Participacion 
	        FROM #Reporte 
			GROUP BY  Id_Concepto_2, Descripcion_2, Id_Concepto_1, Descripcion_1, Id_Concepto, Descripcion
			ORDER BY  Descripcion_2, Descripcion_1, Descripcion

  IF UPPER(@pFormato) = 'RM'
     SELECT DATEPART(yy,Fecha) AS Anio, DATEPART(mm,Fecha) AS Mes , Descripcion,SUM(Importe) AS Importe, CONVERT(DECIMAL(7,2),SUM(Importe) / @Total * 100) AS Participacion 
	        FROM #Reporte 
			GROUP BY DATEPART(yy,Fecha) , DATEPART(mm,Fecha) , Descripcion
			ORDER BY DATEPART(yy,Fecha) , DATEPART(mm,Fecha) , Descripcion

  DROP TABLE #Reporte



/*
EXEC dbo.CPJ_Cbtes_x_Conceptos   '{
			"Id_Usuario":"-1",
			"Equate":"90",
			"FechaDesde":"20210901",
			"FechaHasta":"20210930",
			"Formato":"D",
			"Tipo":"P",
			"Id_Concepto":"155",
			"Flag_Filtrar_Concept":"0"
		}'

EXEC dbo.CPJ_Cbtes_x_Conceptos   '{
			"Id_Usuario":"-1",
			"Equate":"90",
			"FechaDesde":"20100101",
			"FechaHasta":"20210617",
			"Formato":"D",
			"Tipo":"C",
			"Flag_Filtrar_Concept":"0"
		}'

EXEC dbo.CPJ_Cbtes_x_Conceptos   '{
			"Id_Usuario":"-1",
			"Equate":"90",
			"FechaDesde":"20100101",
			"FechaHasta":"20210617",
			"Formato":"D",
			"Tipo":"V",
			"Flag_Filtrar_Concept":"0"
		}'


EXEC dbo.CPJ_Cbtes_x_Conceptos   '{
			"Id_Usuario":"-1",
			"Equate":"90",
			"FechaDesde":"20100101",
			"FechaHasta":"20210617",
			"Formato":"D",
			"Tipo":"R",
			"Flag_Filtrar_Concept":"0"
		}'



EXEC dbo.CPJ_Cbtes_x_Conceptos   '{
			"Id_Usuario":"-1",
			"Equate":"90",
			"FechaDesde":"20100101",
			"FechaHasta":"20210917",
			"Formato":"",
			"Tipo":"P",
			"Flag_Filtrar_Concept":"0"
		}'

EXEC CPJ_Cbtes_x_Conceptos '{"Id_Usuario":"-1","Equate":"130",
"FechaDesde":"20250401","FechaHasta":"20250430",
"Tipo":"n","Formato":"D","id_concepto":"","Flag_Filtrar_Concep":"0"}'


*/

